/*
 * Decompiled with CFR 0.152.
 */
package com.marth7th.solidarytinker.event.common;

import com.marth7th.solidarytinker.config.SolidarytinkerConfig;
import com.marth7th.solidarytinker.register.TinkerCuriosModifier;
import com.marth7th.solidarytinker.register.solidarytinkerEffects;
import com.marth7th.solidarytinker.register.solidarytinkerModifiers;
import com.marth7th.solidarytinker.shelf.damagesource.STDamageSource;
import com.marth7th.solidarytinker.solidarytinker;
import com.marth7th.solidarytinker.util.ModloadCotext;
import com.marth7th.solidarytinker.util.method.ModifierLevel;
import com.xiaoyue.tinkers_ingenuity.utils.ToolUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

@Mod.EventBusSubscriber(modid="solidarytinker")
public class CommonLivingEvent {
    private static final ResourceLocation DEATH = solidarytinker.getResource("death");

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void CommonLivingAttackEvent(LivingAttackEvent event) {
    }

    @SubscribeEvent
    public static void LivingHealEvent(LivingHealEvent event) {
        if (event.getEntity() != null) {
            float value = ((Double)SolidarytinkerConfig.Injured.get()).floatValue();
            if (event.getEntity().m_21023_((MobEffect)solidarytinkerEffects.seriously_injured.get())) {
                int level = event.getEntity().m_21124_((MobEffect)solidarytinkerEffects.seriously_injured.get()).m_19564_() + 1;
                if (level <= 3) {
                    event.setAmount(event.getAmount() * Math.max(1.0f - value * (float)level, 0.0f));
                } else {
                    event.setCanceled(true);
                }
            }
            if (event.getEntity().m_21023_((MobEffect)solidarytinkerEffects.mercurypoisoning.get())) {
                event.setAmount(event.getAmount() * 0.2f);
            }
        }
    }

    private static boolean isBypass(DamageSource source) {
        return source.m_19376_() || source.m_19379_();
    }

    private static float amountShouldCost(Player player, LivingDamageEvent event) {
        if (CommonLivingEvent.isBypass(event.getSource())) {
            return Math.max(player.m_21233_() * 0.3f, 4.0f);
        }
        return Math.max(player.m_21233_() * 0.15f, 2.0f);
    }

    @SubscribeEvent
    public static void TICurioEvents(LivingDamageEvent event) {
        LivingEntity livingEntity;
        if (ModloadCotext.isLoadedIngenuity && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            List curio = ToolUtils.Curios.getStacks((LivingEntity)player);
            float OriginallyDamage = event.getAmount();
            for (ItemStack curios : curio) {
                Player player1;
                if (ModifierUtil.getModifierLevel((ItemStack)curios, (ModifierId)TinkerCuriosModifier.ANGELPROTECT_STATIC_MODIFIER.getId()) <= 0) continue;
                Entity entity = event.getSource().m_7639_();
                if (entity instanceof Player && player != (player1 = (Player)entity) || event.getAmount() > player.m_21233_() * 100.0f) {
                    return;
                }
                float FinalAmount = CommonLivingEvent.amountShouldCost(player, event);
                if (OriginallyDamage > player.m_21233_()) {
                    event.setAmount(FinalAmount * 2.0f);
                    continue;
                }
                if (!(OriginallyDamage > player.m_21233_() * 0.5f)) continue;
                event.setAmount(FinalAmount);
            }
        }
    }

    @SubscribeEvent
    public static void soulGe(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            livingEntity.getPersistentData().m_128473_("ready_to_die");
            return;
        }
        CompoundTag entityData = livingEntity.getPersistentData();
        int dieTick = entityData.m_128451_("ready_to_die");
        LivingEntity attacker = livingEntity.m_21188_();
        if (entityData.m_128441_("ready_to_die")) {
            entityData.m_128405_("ready_to_die", dieTick - 1);
            switch (dieTick) {
                case 1: {
                    CommonLivingEvent.applyDamage(livingEntity, attacker, true);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    CommonLivingEvent.applyDamage(livingEntity, attacker, livingEntity.m_20096_());
                    break;
                }
                case 5: {
                    livingEntity.m_20256_(new Vec3(0.0, -2.5, 0.0));
                }
            }
        }
    }

    private static void applyDamage(LivingEntity entity, LivingEntity attacker, boolean should) {
        CompoundTag data = entity.getPersistentData();
        if (should && attacker instanceof Player) {
            Player player = (Player)attacker;
            entity.m_6469_(DamageSource.m_19344_((Player)player), Float.MAX_VALUE);
            data.m_128473_("ready_to_die");
        } else {
            entity.m_6469_(STDamageSource.MercuryPoisoning, Float.MAX_VALUE);
            data.m_128473_("ready_to_die");
        }
    }

    @SubscribeEvent
    public static void electricBatonExtraDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        int count = entity.getPersistentData().m_128451_("electric_batons_extra_hurt");
        if (count > 0) {
            entity.getPersistentData().m_128405_("electric_batons_extra_hurt", count - 1);
            event.setAmount(event.getAmount() * 1.7f);
        }
    }

    @SubscribeEvent
    public static void corrodeExtraAttack(LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        int count = entity.getPersistentData().m_128451_("corrode_amount");
        if (count >= 50) {
            event.getSource().m_19380_();
        }
    }

    @SubscribeEvent
    public static void corrodeExtraHurt(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        int count = entity.getPersistentData().m_128451_("corrode_amount");
        if (count > 0) {
            event.setAmount(event.getAmount() * 1.0f + (float)count * 0.02f);
        }
    }

    @SubscribeEvent
    public static void corrodeTick(LivingEvent.LivingTickEvent event) {
        int count;
        LivingEntity entity = event.getEntity();
        if (entity.f_19797_ % 200 == 0 && (count = entity.getPersistentData().m_128451_("corrode_amount")) > 0) {
            entity.getPersistentData().m_128405_("corrode_amount", count - 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void LivingDeathEvent(LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_21224_()) {
            ArrayList<ServerPlayer> haveDarkStar = new ArrayList<ServerPlayer>();
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                List playerList = serverLevel.m_6907_();
                for (ServerPlayer players : playerList) {
                    if (!ModifierLevel.inventoryHasThisModifier((LivingEntity)players, solidarytinkerModifiers.DARKSTAR_STATIC_MODIFIER.getId())) continue;
                    haveDarkStar.add(players);
                }
                for (ServerPlayer players : haveDarkStar) {
                    for (ItemStack stack : players.m_150109_().f_35974_) {
                        float max;
                        float count;
                        if (!(stack.m_41720_() instanceof ModifiableItem)) continue;
                        ModDataNBT view = ToolStack.from((ItemStack)stack).getPersistentData();
                        if (ModifierUtil.getModifierLevel((ItemStack)stack, (ModifierId)solidarytinkerModifiers.DARKSTAR_STATIC_MODIFIER.getId()) <= 0 || !((count = view.getFloat(DEATH)) < (max = ((Double)SolidarytinkerConfig.DwarfMaxDamage.get()).floatValue()))) continue;
                        view.putFloat(DEATH, player.m_21233_() * 0.33f / (float)haveDarkStar.size() + 1.0f + view.getFloat(DEATH));
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void MagicUraniumCurio(LivingHurtEvent event) {
        LivingEntity livingEntity;
        if (ModloadCotext.isLoadedIngenuity && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            List curio = ToolUtils.Curios.getStacks((LivingEntity)player);
            float OriginallyDamage = event.getAmount();
            for (ItemStack curios : curio) {
                if (ModifierUtil.getModifierLevel((ItemStack)curios, (ModifierId)TinkerCuriosModifier.CleanCurio.getId()) <= 0) continue;
                List BeneficialEffects = player.m_21220_().stream().toList();
                ArrayList<MobEffect> Beneficial = new ArrayList<MobEffect>();
                for (int i = 0; i < BeneficialEffects.size(); ++i) {
                    MobEffect effect = ((MobEffectInstance)BeneficialEffects.stream().toList().get(i)).m_19544_();
                    if (!effect.m_19486_()) continue;
                    Beneficial.add(effect);
                }
                event.setAmount(OriginallyDamage * Math.max(1.0f - 0.06f * (float)Beneficial.size(), 0.4f));
            }
        }
    }

    @SubscribeEvent
    public static void elysiaCurioTick(TickEvent.PlayerTickEvent event) {
        if (event.player.f_19797_ % 1320 != 0) {
            return;
        }
        Player player = event.player;
        player.m_5634_(player.m_21233_() * 0.66f);
        player.f_19853_.m_5594_(null, player.m_20097_(), SoundEvents.f_215762_, SoundSource.AMBIENT, 1.0f, 1.0f);
    }
}

